<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 27.01.14 11:21
 */

namespace VM\AdminBundle\Services;


use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityManager;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyReport;
use VM\ApiBundle\Entity\GroupRoundReportCode;
use VM\ApiBundle\Entity\Round;
use VM\ApiBundle\Entity\SummaryCompanyRound;
use VM\ApiBundle\Entity\User;
use VM\FinancialStatementsBundle\Services\AccountChanges\AccountChanges;
use VM\FinancialStatementsBundle\Services\FinancialStatementGame;
use VM\FinancialStatementsBundle\Services\Reports\FullReport;
use VM\FinancialStatementsBundle\Services\Reports\SimpleReport;
use VM\PackageGeneratorBundle\Services\Export\ExportProcessCreator;

class RankingService
{
    /**
     * @var ApiGetter
     */
    protected $ApiGetter;

    public function __construct(ApiGetter $ApiGetter)
    {
        $this->ApiGetter = $ApiGetter;
    }

    public function generateRanking(\DateTime $startDate, \DateTime $endDate, $userId = 0)
    {
        $EntityManager = $this->getEntityManager();

        $unsortedCompanies = $EntityManager->getRepository('VMApiBundle:Company')->findAll();
        $unsortedCompanies = new ArrayCollection($unsortedCompanies);
        $iterator = $unsortedCompanies->getIterator();
        $iterator->uasort(function (Company $a, Company $b) {
            return ($a->getId() < $b->getId()) ? -1 : 1;
        });

        $Companies = new ArrayCollection(iterator_to_array($iterator));

        $results = array();
        /** @var $Company Company */
        foreach($Companies as $Company)
        {
            $Teacher = $Company->getUserGroups()->getUser();
            if($userId === 0)
            {
                $globalRanking = true;
            }
            else if($Teacher->getId() === $userId)
            {
                $globalRanking = false;
            }
            else
            {
                continue;
            }

            $Rounds = $Company->getUserGroups()->getRounds();
            $gameStartedAfterDate = false;
            $roundLimitNumber = 0;

            /** @var $Round Round */
            foreach($Rounds as $Round)
            {
                $startAt = $Round->getStartAt();
                if($Round->getSequence() === 1 && !empty($startAt) && $startAt >= $startDate)
                {
                    $gameStartedAfterDate = true;
                }
                if(!empty($startAt))
                {
                    $roundLimitNumber =
                        (($startAt >= $startDate && $startAt <= $endDate) &&
                        $Round->getSequence() > $roundLimitNumber)?
                            $Round->getSequence(): $roundLimitNumber;
                }
            }

            if($gameStartedAfterDate)
            {
                $CompanySummaries = $Company->getSummaryCompanyRound();
                /** @var $SummaryCompanyRound SummaryCompanyRound */
                foreach($CompanySummaries as $SummaryCompanyRound)
                {
                    if($SummaryCompanyRound->getRound()->getSequence() === $roundLimitNumber-1)
                    {
                        $profits = json_decode($SummaryCompanyRound->getResults(), true)['RachunekZyskowIStrat']['zyskNetto'];
                        $profitSum = 0;
                        foreach($profits as $profit)
                        {
                            $profitSum += $profit;
                        }

                        $incomes = json_decode($SummaryCompanyRound->getResults(), true)['RachunekZyskowIStrat']['przychodyNettoZeSprzedazy']['produktow'];
                        $incomeSum = 0;
                        foreach($incomes as $income)
                        {
                            $incomeSum += $income;
                        }

                        if($globalRanking)
                        {
                            $results[$Company->getId()] = array(
                                'company_name' => $Company->getName(),
                                'group_name' => $Company->getUserGroups()->getName(),
                                'profit_sum' => $profitSum,
                                'income_sum' => $incomeSum,
                                'rounds_played' => $roundLimitNumber,
                                'teacher_name' => $Teacher->getName(),
                                'teacher_surname' => $Teacher->getSurname(),
                                'teacher_email' => $Teacher->getEmail()
                            );
                        }
                        else
                        {
                            $results[$Company->getId()] = array(
                                'company_name' => $Company->getName(),
                                'group_name' => $Company->getUserGroups()->getName(),
                                'profit_sum' => $profitSum,
                                'income_sum' => $incomeSum,
                                'rounds_played' => $roundLimitNumber
                            );
                        }
                    }
                }
            }
        }
        return $results;
    }

    /**
     * @return EntityManager
     */
    protected function getEntityManager()
    {
        return $this->ApiGetter->getEntityManager();
    }
}